#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using BROKEN = gov.va.med.vbecs.Common.VbecsBrokenRules.DlgSelectSpecificities;

#endregion
namespace gov.va.med.vbecs.BOL.UnitTests
{

	
	

	[TestFixture]
	public class BOL_ReagentType : BaseTest 
	{

		private BOL.ReagentType _tstRT;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			if (this.RefreshData)
			{
				//Create data just in case
				int reagentTypeId = new Random().Next(11,31);
				short minLevel = (short)new Random().Next(1,99);
				DAL.ReagentType.InsertReagent(reagentTypeId, minLevel, Common.UpdateFunction.UnitTests);

				this.RefreshData = false;
			}

			_tstRT = new gov.va.med.vbecs.BOL.ReagentType();
			this._tstRT.SetInitialBrokenRules(BROKEN.FormClassName, BROKEN.RuleSets.ReagentType);
		}

		[Test]
		public void Ctor_Pass()
		{
			Assert.IsTrue(!_tstRT.Equals(null));
			Assert.AreEqual(_tstRT,_tstRT);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Fail()
		{
		}

		[Test]
		public void Ctor_DataRow_Pass()
		{	
			DataRow dr = DAL.ReagentType.GetReagentQCData(UnitTestConfig.TestDivisionCode, true).Rows[0];
			
			BOL.ReagentType _tstRT = new BOL.ReagentType();

			bool mustUseIndicator = (bool) dr["MustUseIndicator"];

			dr["MustUseIndicator"] = !mustUseIndicator;

			_tstRT = new BOL.ReagentType(dr);
			
			Assert.AreEqual(dr["MustUseIndicator"], !mustUseIndicator);
		}

		[Test]
		[ExpectedExceptionAttribute(typeof(BusinessObjectException))]
		public void Ctor_DataRow_Fail()
		{
			DataTable dt = new DataTable();
			dt.Columns.Add( Guid.Empty.ToString() );
			Assert.IsNull( new BOL.ReagentType( dt.NewRow() ) );
		}
		
		[Test]
		public void Ctor_Int_String_Short_Pass()
		{
			_tstRT = new BOL.ReagentType(57,"LISS",0);
			Assert.IsNotNull( _tstRT );
		}

				
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void Ctor_Int_String_Short_Fail()
		{
		}

		[Test]
		public void ReagentTypeID_Pass()
		{
			System.Int32 _ReagentTypeID;
			_ReagentTypeID = _tstRT.ReagentTypeId;
			Assert.AreEqual(_tstRT.ReagentTypeId,_ReagentTypeID);
		}

		
		[Test]
		public void ReagentTypeID_Fail()
		{
			int tstValue = new Random().Next(-999,0);

			this._tstRT.ReagentTypeId = tstValue;

			Assert.AreEqual(tstValue, this._tstRT.ReagentTypeId, "Value");
			Assert.AreEqual(true, this._tstRT.IsRuleBroken(BROKEN.ReagentTypeId), "BrokenRule");
		}

		[Test]
		public void TestWithName_Pass()
		{
			string testWithName = "";
			testWithName = _tstRT.TestWithName;
			Assert.AreEqual(_tstRT.TestWithName, testWithName);
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestWithName_Fail()
		{
		}

		[Test]
		public void ReactivityPhaseCode_Pass()
		{
			string tstValue = System.DateTime.Now.ToString();

			_tstRT.ReactivityPhaseCode = tstValue;

			Assert.AreEqual(_tstRT.ReactivityPhaseCode, tstValue);
		}


		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReactivityPhaseCode_Fail()
		{
		}

		[Test]
		public void ReagentTypeName_Pass()
		{
			System.String _ReagentTypeName;
			_ReagentTypeName = _tstRT.ReagentTypeName;
			Assert.AreEqual(_tstRT.ReagentTypeName,_ReagentTypeName);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentTypeName_Fail()
		{
		}


		[Test]
		public void CanChangeIndicator_Pass()
		{
			bool canChangeIndicator;
			canChangeIndicator = _tstRT.CanChangeIndicator;
			Assert.AreEqual(_tstRT.CanChangeIndicator,canChangeIndicator);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CanChangeIndicator_Fail()
		{
		}

		[Test]
		public void MinimumStockLevel_Pass()
		{
			System.Int16 _MinimumStockLevel;
			_MinimumStockLevel = _tstRT.MinimumStockLevel;
			Assert.AreEqual(_tstRT.MinimumStockLevel,_MinimumStockLevel);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void MinimumStockLevel_Fail()
		{
		}

		[Test]
		public void MustUseIndicator_Pass()
		{
			bool mustUseIndicator;
			mustUseIndicator = _tstRT.MustUseIndicator;
			Assert.AreEqual(_tstRT.MustUseIndicator,mustUseIndicator);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void MustUseIndicator_Fail()
		{
		}

		[Test]
		public void ExpectedMinimumReaction_Pass()
		{
			string expectedMinimumReaction = "";
			expectedMinimumReaction = _tstRT.ExpectedMinimumReaction;
			Assert.AreEqual(_tstRT.ExpectedMinimumReaction,expectedMinimumReaction);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ExpectedMinimumReaction_Fail()
		{
		}

		[Test]
		public void ExpectedMinimumReactionTestResultText_Pass()
		{
			string expectedMinimumReactionTestResultText = "";
			expectedMinimumReactionTestResultText = _tstRT.ExpectedMinimumReactionTestResultText;
			Assert.AreEqual(_tstRT.ExpectedMinimumReactionTestResultText,expectedMinimumReactionTestResultText);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ExpectedMinimumReactionTestResultText_Fail()
		{
		}

		[Test]
		public void DailyUseIndicator_Pass()
		{
			bool dailyUseIndicator;
			dailyUseIndicator = _tstRT.DailyUseIndicator;
			Assert.AreEqual(_tstRT.DailyUseIndicator,dailyUseIndicator);
		}
		
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void DailyUseIndicator_Fail()
		{
		}

		[Test]
		public void SortColumn_Pass()
		{
			System.Int32 _SortColumn;
			_SortColumn = _tstRT.SortColumn;
			Assert.AreEqual(_tstRT.SortColumn,_SortColumn);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SortColumn_Fail()
		{
		}

		[Test]
		public void SaveReagentStockLevels_Pass()
		{	
			DataRow dr = DAL.ReagentType.GetExistingMinimumLevels(UnitTestConfig.TestDivisionCode).Rows[0];
			BOL.ReagentType rType = new BOL.ReagentType( (int) dr[TABLES.ReagentType.ReagentTypeId],"Foo",14);
			rType.RowVersion = (byte[]) dr["RowVersion"];
			Assert.IsTrue(rType.SaveReagentStockLevels(Common.UpdateFunction.UnitTests));
		}

		[Test]
        [ExpectedExceptionAttribute(typeof(Common.DataAccessLayerException))]
		public void SaveReagentStockLevels_Fail()
		{
			BOL.ReagentType rType = new BOL.ReagentType( -1,"",-2);
			rType.SaveReagentStockLevels(Common.UpdateFunction.UnitTests);
		}

		[Test]
		public void GetCanChangeExpectedMinReactions_Pass()
		{
			System.Collections.ArrayList al = DAL.ReagentType.GetCanChangeExpectedMinReactions();
			Assert.IsTrue(al.Count > 0);
		}

		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetCanChangeExpectedMinReactions_Fail()
		{
		}

		[Test]
		public void GetReagentQCCommercialData_Pass()
		{
			Assert.IsTrue(DAL.ReagentType.GetReagentQCData(UnitTestConfig.TestDivisionCode, true) != null);
		}

		[Test]
		public void GetReagentQCCommercialData_Fail()
		{
			Assert.IsTrue(DAL.ReagentType.GetReagentQCData("", true).Rows.Count == 0);
		}

		[Test]
		public void GetReagentQCNonCommercialData_Pass()
		{
			Assert.IsTrue(DAL.ReagentType.GetReagentQCData(UnitTestConfig.TestDivisionCode, false) != null);
		}

		[Test]
		public void GetReagentQCNonCommercialData_Fail()
		{
			Assert.IsTrue(DAL.ReagentType.GetReagentQCData("", false).Rows.Count == 0);
		}

		[Test]
		public void InsertReagent_Pass()
		{
			int reagentTypeId = new Random().Next(10,31);
			short minLevel = (short)new Random().Next(1,99);

			BOL.ReagentType tmpRT = new ReagentType(reagentTypeId, "UnitTest", minLevel);

			bool retValue = tmpRT.InsertReagent(Common.UpdateFunction.UnitTests);
			Assert.AreEqual(true, retValue);
		}
		
		[Test]
        [ExpectedExceptionAttribute(typeof(Common.DataAccessLayerException))]
		public void InsertReagent_Fail()
		{
			BOL.ReagentType tmpRT = new ReagentType(int.MinValue, string.Empty, short.MaxValue);

			bool retValue = tmpRT.InsertReagent(Common.UpdateFunction.UnitTests);
		}


		[Test]
		public void GetReagentTypes_Pass()
		{
			DataTable dtReagentTypes = DAL.ReagentType.GetReagentTypes();
			Assert.IsTrue(dtReagentTypes.Rows.Count > 0);
		}
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetReagentTypes_Fail()
		{
		}

		[Test]
		public void GetExistingMinimumLevels_Pass()
		{	
			string sSQL = "SELECT COUNT(*) FROM ReagentTypeParameter WHERE DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'";

			DataTable tmpData = UnitTestUtil.RunSQLGetDataTable(sSQL);

			int rows = System.Convert.ToInt16(tmpData.Rows[0][0]);

			DataTable dtReagentTypes = DAL.ReagentType.GetExistingMinimumLevels(UnitTestConfig.TestDivisionCode);
			Assert.AreEqual(dtReagentTypes.Rows.Count, rows);
		}

		[Test]
		public void GetExistingMinimumLevels_Fail()
		{	
			DataTable dtReagentTypes = DAL.ReagentType.GetExistingMinimumLevels("");
			Assert.IsTrue(dtReagentTypes.Rows.Count == 0);
		}

		[Test]
		public void GetDailyQCReagentTypes_Pass()
		{
			DataTable dtReagentTypes = DAL.ReagentType.GetDailyQCReagentTypes(UnitTestConfig.TestDivisionCode);
			Assert.IsTrue(dtReagentTypes != null);
		}

		[Test]
		public void GetDailyQCReagentTypes_Fail()
		{
			DataTable dtReagentTypes = DAL.ReagentType.GetDailyQCReagentTypes("");
			Assert.IsTrue(dtReagentTypes.Rows.Count == 0);
		}

		[Test]
		public void LoadDataRowFromThis_Pass()
		{	
			DataRow dr = DAL.ReagentType.GetReagentQCData(UnitTestConfig.TestDivisionCode, true).Rows[0];
			
			BOL.ReagentType _tstRT = new BOL.ReagentType();
			
			_tstRT.MustUseIndicator = (bool) dr["MustUseIndicator"];

			//
			BOL.ReagentType _tstRT2 = new BOL.ReagentType();
			_tstRT2 = new BOL.ReagentType(dr);
			//
			Assert.AreEqual(_tstRT.MustUseIndicator,_tstRT2.MustUseIndicator);
		}
		
		
		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LoadDataRowFromThis_Fail()
		{
		}

		[Test]
		public void VerifyMinColumnsInDataTable_Pass()
		{
			DataTable dt = DAL.ReagentType.GetReagentQCData(UnitTestConfig.TestDivisionCode, true);
			const string REAGENTTYPECOLUMNSTEST = "ReagentTypeId,ReagentTypeName";

			Assert.IsTrue(Common.Utility.VerifyMinColumnsInDataTable(REAGENTTYPECOLUMNSTEST.Split(','), dt));

		}
		
		[Test]
		public void VerifyMinColumnsInDataTable_Fail()
		{
			const string REAGENTTYPECOLUMNSTEST = "ReagentTypeId,ReagentTypeName";

			Assert.IsTrue(Common.Utility.VerifyMinColumnsInDataTable(REAGENTTYPECOLUMNSTEST.Split(','), new DataTable()) == false);

		}

		[Test]
		public void TestWithId_Pass()
		{
			this._tstRT.TestWithId = 101;
			Assert.AreEqual(this._tstRT.TestWithId, 101);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void TestWithId_Fail()
		{
		}

		[Test]
		public void SetVialId_Pass()
		{
			this._tstRT.SetVialId = "TESTSTRING";
			Assert.AreEqual(this._tstRT.SetVialId, "TESTSTRING");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void SetVialId_Fail()
		{
		}

		[Test]
		public void ReagentTypeParameterGuid_Pass()
		{
			System.Guid tstGuid = System.Guid.NewGuid();

			this._tstRT.ReagentTypeParameterGuid = tstGuid;
			Assert.AreEqual(this._tstRT.ReagentTypeParameterGuid, tstGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentTypeParameterGuid_Fail()
		{
		}

		[Test]
		public void ReagentTestParameterGuid_Pass()
		{
			System.Guid tstGuid = System.Guid.NewGuid();

			this._tstRT.ReagentTestParameterGuid = tstGuid;
			Assert.AreEqual(this._tstRT.ReagentTestParameterGuid, tstGuid);
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void ReagentTestParameterGuid_Fail()
		{
		}

		[Test]
		public void GetAntigenTypingReagentTypes_Pass()
		{
			DataTable types = BOL.ReagentType.GetAntigenTypingReagentTypes();
			//
			Assert.IsTrue( types.Rows.Count > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntigenTypingReagentTypes_Fail()
		{
		}

		[Test]
		public void GetAntigenTypingQCReagentTypes_Pass()
		{
			DataTable types = BOL.ReagentType.GetAntigenTypingQCReagentTypes();
			//
			Assert.IsTrue( types.Rows.Count > 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetAntigenTypingQCReagentTypes_Fail()
		{
		}

		[Test]
		public void GetDailyQCReagentTypesForPartiallyCompletedQc_Pass()
		{
			DataRow dr = UnitTestUtil.RunSQLGetDataRow( "SELECT TOP 1 DailyQcWorklistGuid FROM dbo.RackLot WHERE DailyQcWorklistGuid IS NOT NULL" );
			//
			Guid dailyQcWorklistGuid = (Guid)dr[TABLES.RackLot.DailyQcWorklistGuid];
			//
			DataTable types = BOL.ReagentType.GetDailyQCReagentTypesForPartiallyCompletedQc( dailyQcWorklistGuid );
			//
			Assert.IsTrue( types.Rows.Count >= 0 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetDailyQCReagentTypesForPartiallyCompletedQc_Fail()
		{
		}

		[Test]
		public void CheckScreeningCell3And4_Pass()
		{
			const int SC = 63; 
			const string SCVIALID3 = "3";
			const string SCVIALID4 = "4";
			const string TEST = "7";
			//
			int prevId = this._tstRT.ReagentTypeId;
			//
			this._tstRT.ReagentTypeId = SC;
			this._tstRT.SetVialId = SCVIALID3;
			//
			Assert.IsTrue( this._tstRT.CheckScreeningCell3And4() );
			//
			this._tstRT.SetVialId = SCVIALID4;
			//
			Assert.IsTrue( this._tstRT.CheckScreeningCell3And4() );
			//
			this._tstRT.ReagentTypeId = 77;
			this._tstRT.SetVialId = TEST;
			//
			Assert.IsTrue( !this._tstRT.CheckScreeningCell3And4() );
			//
			this._tstRT.ReagentTypeId = prevId;
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void CheckScreeningCell3And4_Fail()
		{
		}
	}
}

#endif





